<?php

namespace app\controllers;

use app\models\Application;
use app\models\ApplicationForm;
use app\models\CommentForm;
use Yii;
use yii\web\Controller;

class ApplicationController extends Controller
{
    public function actionIndex()
    {
        if (Yii::$app->user->isGuest) {
            return $this->redirect('/site/register');
        }

        $model = Application::find()->where(['user_id' => \Yii::$app->user->id])->all();

        return $this->render('index', ['model' => $model]);
    }

    public function actionForm(){
        if (Yii::$app->user->isGuest) {
            return $this->redirect('/site/register');
        }

        $model = new ApplicationForm();
        if ($model->load(Yii::$app->request->post()) && $model->appSave()) {
            return $this->redirect(['index']);
        }

        return $this->render('form', ['model' => $model]);
    }

    public function actionComment($id){
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $application = Application::findOne($id);

        $model = new CommentForm();
        $model->application_id = $id;
        if ($model->load(Yii::$app->request->post()) && $model->commSave()) {
            Yii::$app->session->setFlash('success', 'Отзыв добавлен');
            return $this->redirect(['index']);
        }
        return $this->render('comment', [
            'application' => $application,
            'model' => $model,
        ]);
    }
}