<?php

namespace app\models;

use Yii;
use yii\base\Model;

class CommentForm extends Model
{
    public $text;
    public $application_id;

    public function rules()
    {
        return [
            [['text'], 'required'],
        ];
    }
    public function attributeLabels()
    {
        return [
            'text' => 'Текст комментария',
        ];
    }

    public function commSave()
    {
        if (!$this->validate()) {
            Yii::error('Validation failed: ' . print_r($this->errors, true));
            return false;
        }
        $comm = new Comment();
        $comm->text = $this->text;
        $comm->user_id = Yii::$app->user->getId();
        $comm->application_id = $this->application_id;
        if ($comm->save()) {
            return true;
        } else {
            Yii::error('Save failed: ' . print_r($comm->errors, true));
            return false;
        }
    }


}
