<?php

namespace app\models;

use Yii;
use yii\base\Model;

/**
 * LoginForm is the model behind the login form.
 *
 * @property-read User|null $user
 *
 */
class RegisterForm extends Model
{
    public $login;
    public $password;
    public $first_name;
    public $last_name;
    public $patronymic;
    public $email;
    public $phone;

    /**
     * @return array the validation rules.
     */
    public function rules()
    {
        return [
            [['login', 'password', 'first_name', 'last_name', 'email', 'phone', 'patronymic'], 'required'],
            ['email', 'email'],
            ['login', 'unique', 'targetClass' => 'app\models\User'],
            ['login', 'string', 'min' => 5, 'max' => 30],
            ['login', 'match', 'pattern' => '/^[a-zA-Z0-9\s]+$/u', 'message' => 'Логин может содержать только латинские буквы и цифры'],
            ['password', 'string', 'min' => 8, 'max' => 30],
            [['first_name', 'last_name', 'patronymic'], 'match', 'pattern' => '/^[а-яА-ЯёЁ\s]+$/u', 'message' => 'Поле может содержать только кириллические буквы, пробелы и дефисы'],
        ];
    }

    public function register()
    {
        if (!$this->validate()) {
            return false;
        }
        $user = new User();
        $user->first_name = $this->first_name;
        $user->last_name = $this->last_name;
        $user->patronymic = $this->patronymic;
        $user->phone = $this->phone;
        $user->email = $this->email;
        $user->password = Yii::$app->getSecurity()->generatePasswordHash($this->password);
        $user->login = $this->login;
        if ($user->save()) {
            return true;
        }
        return false;
    }

    public function attributeLabels()
    {
        return [
            'login' => 'Логин',
            'first_name' => 'Имя',
            'last_name' => 'Фамилия',
            'patronymic' => 'Отчество',
            'phone' => 'Телефон',
            'password' => 'Пароль',
        ];
    }
}
