<?php

use yii\helpers\Html;

/** @var yii\web\View $this */
/** @var app\models\Application $model */

$this->title = Yii::t('app', 'Изменение статуса заявки: {name}', [
    'name' => $model->title,
]);
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Заявки'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->title, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = Yii::t('app', 'Редактирование');
?>
    <div class="application-update-container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10">
                <!-- Карточка редактирования -->
                <div class="card update-card border-0 shadow-lg rounded-4">
                    <div class="card-body p-5">
                        <!-- Заголовок -->
                        <div class="text-center mb-5">
                            <div class="update-icon mb-4">
                                <div class="icon-wrapper bg-warning rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                    <i class="fas fa-edit text-white" style="font-size: 2rem;"></i>
                                </div>
                            </div>
                            <h1 class="h2 fw-bold text-dark mb-2">Изменение статуса заявки</h1>
                            <p class="text-muted">Обновите информацию о текущем статусе заявки</p>
                        </div>

                        <!-- Информация о заявке -->
                        <div class="application-info mb-5">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-card bg-light rounded-3 p-4 mb-3">
                                        <h6 class="fw-bold text-dark mb-3">
                                            <i class="fas fa-info-circle text-primary me-2"></i>Информация о заявке
                                        </h6>
                                        <div class="info-item mb-2">
                                            <small class="text-muted d-block">Название курса:</small>
                                            <strong class="text-dark"><?= Html::encode($model->title) ?></strong>
                                        </div>
                                        <div class="info-item mb-2">
                                            <small class="text-muted d-block">Дата создания:</small>
                                            <strong class="text-dark"><?= Yii::$app->formatter->asDate($model->date) ?></strong>
                                        </div>
                                        <div class="info-item">
                                            <small class="text-muted d-block">Пользователь:</small>
                                            <strong class="text-dark"><?= Html::encode($model->user->login ?? 'Не указан') ?></strong>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="info-card bg-light rounded-3 p-4 mb-3">
                                        <h6 class="fw-bold text-dark mb-3">
                                            <i class="fas fa-chart-line text-success me-2"></i>Текущий статус
                                        </h6>
                                        <div class="current-status text-center py-3">
                                            <?php
                                            $statusConfig = [
                                                0 => ['class' => 'bg-warning', 'icon' => 'clock', 'text' => 'Новая'],
                                                1 => ['class' => 'bg-info', 'icon' => 'sync-alt', 'text' => 'Идет обучение'],
                                                2 => ['class' => 'bg-success', 'icon' => 'check-circle', 'text' => 'Завершено']
                                            ];
                                            $config = $statusConfig[$model->status] ?? $statusConfig[0];
                                            ?>
                                            <div class="status-badge <?= $config['class'] ?> text-white rounded-pill px-4 py-2 d-inline-block mb-2">
                                                <i class="fas fa-<?= $config['icon'] ?> me-2"></i>
                                                <?= $config['text'] ?>
                                            </div>
                                            <div class="status-progress mt-3">
                                                <div class="progress" style="height: 8px;">
                                                    <?php
                                                    $progressWidth = [
                                                        0 => 33,
                                                        1 => 66,
                                                        2 => 100
                                                    ];
                                                    $width = $progressWidth[$model->status] ?? 0;
                                                    ?>
                                                    <div class="progress-bar <?= $config['class'] ?>"
                                                         role="progressbar"
                                                         style="width: <?= $width ?>%"
                                                         aria-valuenow="<?= $width ?>"
                                                         aria-valuemin="0"
                                                         aria-valuemax="100">
                                                    </div>
                                                </div>
                                                <div class="d-flex justify-content-between mt-2">
                                                    <small class="text-muted <?= $model->status >= 0 ? 'text-warning fw-bold' : '' ?>">
                                                        Новая
                                                    </small>
                                                    <small class="text-muted <?= $model->status >= 1 ? 'text-info fw-bold' : '' ?>">
                                                        В процессе
                                                    </small>
                                                    <small class="text-muted <?= $model->status >= 2 ? 'text-success fw-bold' : '' ?>">
                                                        Завершено
                                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Форма редактирования -->
                        <div class="update-form-section">
                            <div class="section-header mb-4">
                                <h4 class="fw-bold text-dark">
                                    <i class="fas fa-cog me-2 text-primary"></i>Настройки статуса
                                </h4>
                                <p class="text-muted mb-0">Выберите новый статус для заявки</p>
                            </div>

                            <?= $this->render('_form', [
                                'model' => $model,
                            ]) ?>

                            <!-- Дополнительные опции -->
                            <div class="additional-options mt-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="notifyUser">
                                    <label class="form-check-label text-muted" for="notifyUser">
                                        <i class="fas fa-bell me-2"></i>Уведомить пользователя об изменении статуса
                                    </label>
                                </div>
                                <div class="form-check mt-2">
                                    <input class="form-check-input" type="checkbox" id="addComment">
                                    <label class="form-check-label text-muted" for="addComment">
                                        <i class="fas fa-comment me-2"></i>Добавить комментарий к изменению
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Кнопки действий -->
                        <div class="action-buttons mt-5 pt-4 border-top">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="d-grid gap-2">
                                        <?= Html::submitButton('<i class="fas fa-save me-2"></i>Сохранить изменения', [
                                            'class' => 'btn btn-primary btn-lg py-3 fw-semibold rounded-3 shadow',
                                            'form' => 'application-form'
                                        ]) ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="d-grid gap-2">
                                        <?= Html::a('<i class="fas fa-arrow-left me-2"></i>Вернуться к списку',
                                            ['index'],
                                            ['class' => 'btn btn-outline-secondary btn-lg py-3 fw-semibold rounded-3']
                                        ) ?>
                                        <?= Html::a('<i class="fas fa-eye me-2"></i>Просмотр заявки',
                                            ['view', 'id' => $model->id],
                                            ['class' => 'btn btn-outline-primary btn-lg py-3 fw-semibold rounded-3 mt-2']
                                        ) ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- История изменений -->
                        <div class="change-history mt-5">
                            <div class="card border-0 bg-light">
                                <div class="card-body">
                                    <h6 class="fw-bold text-dark mb-3">
                                        <i class="fas fa-history me-2 text-muted"></i>Последние изменения
                                    </h6>
                                    <div class="timeline">
                                        <div class="timeline-item">
                                            <div class="timeline-marker bg-success"></div>
                                            <div class="timeline-content">
                                                <small class="text-muted">Сегодня, 10:30</small>
                                                <p class="mb-1">Статус изменен на "Новая"</p>
                                                <small class="text-muted">Администратор: Иванов И.И.</small>
                                            </div>
                                        </div>
                                        <div class="timeline-item">
                                            <div class="timeline-marker bg-primary"></div>
                                            <div class="timeline-content">
                                                <small class="text-muted">Вчера, 14:15</small>
                                                <p class="mb-1">Заявка создана</p>
                                                <small class="text-muted">Система</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$this->registerCss(<<<CSS
    .application-update-container {
        padding: 2rem 0;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        min-height: 100vh;
    }
    
    .update-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
    }
    
    .update-icon {
        transition: transform 0.3s ease;
    }
    
    .update-card:hover .update-icon {
        transform: scale(1.05);
    }
    
    .info-card {
        transition: all 0.3s ease;
        height: 100%;
        border: 1px solid rgba(0,0,0,0.05);
    }
    
    .info-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .status-badge {
        font-weight: 600;
        font-size: 0.9rem;
    }
    
    .status-progress .progress {
        background-color: #e9ecef;
        border-radius: 10px;
    }
    
    .status-progress .progress-bar {
        border-radius: 10px;
        transition: width 0.8s ease;
    }
    
    /* Стили для временной линии */
    .timeline {
        position: relative;
        padding-left: 2rem;
    }
    
    .timeline-item {
        position: relative;
        padding-bottom: 1.5rem;
    }
    
    .timeline-marker {
        position: absolute;
        left: -2rem;
        top: 0.25rem;
        width: 12px;
        height: 12px;
        border-radius: 50%;
        border: 3px solid white;
        box-shadow: 0 0 0 3px #e9ecef;
    }
    
    .timeline-content {
        background: white;
        padding: 1rem;
        border-radius: 8px;
        border: 1px solid #f1f3f4;
    }
    
    .timeline-item:not(:last-child):before {
        content: '';
        position: absolute;
        left: -1.7rem;
        top: 1.2rem;
        bottom: -0.5rem;
        width: 2px;
        background: #e9ecef;
    }
    
    /* Стили формы */
    .form-check-input:checked {
        background-color: #4361ee;
        border-color: #4361ee;
    }
    
    .form-check-input:focus {
        border-color: #4361ee;
        box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
    }
    
    /* Кнопки */
    .btn-primary {
        background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
        border: none;
        transition: all 0.3s ease;
    }
    
    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(67, 97, 238, 0.3) !important;
    }
    
    .btn-outline-primary, .btn-outline-secondary {
        transition: all 0.3s ease;
        border-width: 2px;
    }
    
    .btn-outline-primary:hover, .btn-outline-secondary:hover {
        transform: translateY(-2px);
    }
    
    /* Анимации */
    @keyframes slideInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .update-card {
        animation: slideInUp 0.8s ease-out;
    }
    
    /* Градиенты для статусов */
    .bg-warning {
        background: linear-gradient(135deg, #ffc107 0%, #ffb300 100%) !important;
    }
    
    .bg-info {
        background: linear-gradient(135deg, #17a2b8 0%, #6f42c1 100%) !important;
    }
    
    .bg-success {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%) !important;
    }
    
    /* Адаптивность */
    @media (max-width: 768px) {
        .application-update-container {
            padding: 1rem;
        }
        
        .update-card {
            margin: 0;
            padding: 2rem 1.5rem !important;
        }
        
        .btn-lg {
            padding: 0.75rem 1.5rem;
        }
        
        .h2 {
            font-size: 1.75rem;
        }
        
        .action-buttons .row > div {
            margin-bottom: 1rem;
        }
        
        .info-card {
            margin-bottom: 1rem;
        }
    }
    
    /* Дополнительные стили */
    .section-header {
        border-bottom: 2px solid #f1f3f4;
        padding-bottom: 1rem;
    }
    
    .additional-options {
        background: #f8f9ff;
        padding: 1.5rem;
        border-radius: 12px;
        border: 1px dashed #4361ee;
    }
    
    .action-buttons {
        background: linear-gradient(135deg, #f8f9ff 0%, #ffffff 100%);
    }
CSS
);

$this->registerJs(<<<JS
    // Анимация при изменении статуса
    $('#application-status').on('change', function() {
        const status = $(this).val();
        const progressBar = $('.status-progress .progress-bar');
        const statusBadge = $('.status-badge');
        
        // Конфигурация статусов
        const statusConfig = {
            '0': {width: 33, class: 'bg-warning', icon: 'clock', text: 'Новая'},
            '1': {width: 66, class: 'bg-info', icon: 'sync-alt', text: 'Идет обучение'},
            '2': {width: 100, class: 'bg-success', icon: 'check-circle', text: 'Завершено'}
        };
        
        const config = statusConfig[status] || statusConfig['0'];
        
        // Анимация прогресс-бара
        progressBar.animate({width: config.width + '%'}, 800);
        
        // Обновление бейджа статуса
        setTimeout(() => {
            statusBadge.removeClass('bg-warning bg-info bg-success')
                      .addClass(config.class)
                      .html('<i class="fas fa-' + config.icon + ' me-2"></i>' + config.text);
        }, 400);
        
        // Анимация изменения
        $(this).closest('.form-group').css('transform', 'scale(1.02)');
        setTimeout(() => {
            $(this).closest('.form-group').css('transform', 'scale(1)');
        }, 200);
    });
    
    // Подсветка чекбоксов при наведении
    $('.form-check-input').on('mouseenter', function() {
        $(this).closest('.form-check').css('transform', 'translateX(5px)');
    }).on('mouseleave', function() {
        $(this).closest('.form-check').css('transform', 'translateX(0)');
    });
    
    // Валидация формы
    $('#application-form').on('submit', function(e) {
        const status = $('#application-status').val();
        if (status === '') {
            e.preventDefault();
            $('#application-status').focus();
            $('#application-status').addClass('is-invalid');
            
            // Анимация ошибки
            $('#application-status').css('transform', 'translateX(10px)');
            setTimeout(() => {
                $('#application-status').css('transform', 'translateX(0)');
            }, 300);
        }
    });
    
    // Убрать ошибку при выборе статуса
    $('#application-status').on('change', function() {
        if ($(this).val() !== '') {
            $(this).removeClass('is-invalid');
        }
    });
JS
);
?>