<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\Application $model */

$this->title = $model->title;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Заявки'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
    <div class="application-view-container">
        <div class="row justify-content-center">
            <div class="col-xl-10 col-lg-12">
                <!-- Карточка просмотра заявки -->
                <div class="card view-card border-0 shadow-lg rounded-4">
                    <div class="card-body p-5">
                        <!-- Заголовок и действия -->
                        <div class="d-flex justify-content-between align-items-start mb-5">
                            <div class="flex-grow-1">
                                <div class="view-icon mb-4">
                                    <div class="icon-wrapper bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 70px; height: 70px;">
                                        <i class="fas fa-file-invoice text-white" style="font-size: 1.8rem;"></i>
                                    </div>
                                </div>
                                <h1 class="h2 fw-bold text-dark mb-2"><?= Html::encode($this->title) ?></h1>
                                <p class="text-muted mb-0">Детальная информация о заявке на обучение</p>
                            </div>
                            <div class="action-buttons">
                                <div class="btn-group-vertical">
                                    <?= Html::a('<i class="fas fa-edit me-2"></i>Редактировать', ['update', 'id' => $model->id], [
                                        'class' => 'btn btn-primary btn-lg mb-2 rounded-3 px-4 py-2 shadow'
                                    ]) ?>
                                    <?= Html::a('<i class="fas fa-trash me-2"></i>Удалить', ['delete', 'id' => $model->id], [
                                        'class' => 'btn btn-danger btn-lg rounded-3 px-4 py-2 shadow',
                                        'data' => [
                                            'confirm' => Yii::t('app', 'Вы уверены, что хотите удалить эту заявку?'),
                                            'method' => 'post',
                                        ],
                                    ]) ?>
                                </div>
                            </div>
                        </div>

                        <!-- Основная информация в карточках -->
                        <div class="row mb-5">
                            <div class="col-md-3">
                                <div class="info-card bg-primary text-white rounded-4 p-4 text-center shadow">
                                    <div class="info-icon mb-3">
                                        <i class="fas fa-hashtag fa-2x opacity-75"></i>
                                    </div>
                                    <h3 class="fw-bold mb-1">#<?= $model->id ?></h3>
                                    <p class="mb-0 opacity-90">ID заявки</p>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-card bg-success text-white rounded-4 p-4 text-center shadow">
                                    <div class="info-icon mb-3">
                                        <i class="fas fa-calendar-day fa-2x opacity-75"></i>
                                    </div>
                                    <h3 class="fw-bold mb-1"><?= Yii::$app->formatter->asDate($model->date) ?></h3>
                                    <p class="mb-0 opacity-90">Дата создания</p>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-card bg-info text-white rounded-4 p-4 text-center shadow">
                                    <div class="info-icon mb-3">
                                        <i class="fas fa-user fa-2x opacity-75"></i>
                                    </div>
                                    <h3 class="fw-bold mb-1"><?= Html::encode($model->user->login ?? 'Не указан') ?></h3>
                                    <p class="mb-0 opacity-90">Пользователь</p>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-card bg-warning text-white rounded-4 p-4 text-center shadow">
                                    <div class="info-icon mb-3">
                                        <i class="fas fa-credit-card fa-2x opacity-75"></i>
                                    </div>
                                    <h3 class="fw-bold mb-1"><?= $model->getPay() ?></h3>
                                    <p class="mb-0 opacity-90">Способ оплаты</p>
                                </div>
                            </div>
                        </div>

                        <!-- Детальная информация -->
                        <div class="detailed-info">
                            <div class="row">
                                <div class="col-lg-8">
                                    <!-- Основные атрибуты -->
                                    <div class="card border-0 rounded-4 shadow-sm mb-4">
                                        <div class="card-header bg-transparent border-0 p-4">
                                            <h4 class="card-title fw-bold text-dark mb-0">
                                                <i class="fas fa-info-circle me-2 text-primary"></i>Основная информация
                                            </h4>
                                        </div>
                                        <div class="card-body p-4">
                                            <?= DetailView::widget([
                                                'model' => $model,
                                                'attributes' => [
                                                    [
                                                        'attribute' => 'id',
                                                        'label' => 'ID заявки',
                                                        'format' => 'raw',
                                                        'value' => function($model) {
                                                            return '<span class="badge bg-primary fs-6">#' . $model->id . '</span>';
                                                        },
                                                        'contentOptions' => ['class' => 'fw-bold']
                                                    ],
                                                    [
                                                        'attribute' => 'title',
                                                        'label' => 'Название курса',
                                                        'format' => 'raw',
                                                        'value' => function($model) {
                                                            return '<div class="d-flex align-items-center">
                                                                    <i class="fas fa-book text-primary me-3 fs-5"></i>
                                                                    <span class="fw-semibold">' . Html::encode($model->title) . '</span>
                                                                </div>';
                                                        }
                                                    ],
                                                    [
                                                        'attribute' => 'date',
                                                        'label' => 'Дата создания',
                                                        'format' => 'raw',
                                                        'value' => function($model) {
                                                            return '<div class="d-flex align-items-center">
                                                                    <i class="fas fa-calendar text-success me-3 fs-5"></i>
                                                                    <span class="fw-semibold">' . Yii::$app->formatter->asDate($model->date) . '</span>
                                                                </div>';
                                                        }
                                                    ],
                                                    [
                                                        'attribute' => 'user_id',
                                                        'label' => 'Пользователь',
                                                        'format' => 'raw',
                                                        'value' => function($model) {
                                                            return '<div class="d-flex align-items-center">
                                                                    <i class="fas fa-user text-info me-3 fs-5"></i>
                                                                    <span class="fw-semibold">' . Html::encode($model->user->login ?? 'Не указан') . '</span>
                                                                </div>';
                                                        }
                                                    ],
                                                ],
                                                'options' => ['class' => 'table table-borderless mb-0'],
                                            ]) ?>
                                        </div>
                                    </div>

                                    <!-- Статус и оплата -->
                                    <div class="card border-0 rounded-4 shadow-sm">
                                        <div class="card-header bg-transparent border-0 p-4">
                                            <h4 class="card-title fw-bold text-dark mb-0">
                                                <i class="fas fa-cog me-2 text-warning"></i>Статус и настройки
                                            </h4>
                                        </div>
                                        <div class="card-body p-4">
                                            <?= DetailView::widget([
                                                'model' => $model,
                                                'attributes' => [
                                                    [
                                                        'attribute' => 'status',
                                                        'label' => 'Текущий статус',
                                                        'format' => 'raw',
                                                        'value' => function($model) {
                                                            $statusConfig = [
                                                                0 => ['class' => 'bg-warning', 'icon' => 'clock', 'text' => 'Новая'],
                                                                1 => ['class' => 'bg-info', 'icon' => 'sync-alt', 'text' => 'Идет обучение'],
                                                                2 => ['class' => 'bg-success', 'icon' => 'check-circle', 'text' => 'Завершено']
                                                            ];
                                                            $config = $statusConfig[$model->status] ?? $statusConfig[0];
                                                            return '<span class="badge ' . $config['class'] . ' fs-6 px-3 py-2">
                                                                    <i class="fas fa-' . $config['icon'] . ' me-2"></i>' . $config['text'] . '
                                                                </span>';
                                                        }
                                                    ],
                                                    [
                                                        'attribute' => 'pay',
                                                        'label' => 'Способ оплаты',
                                                        'format' => 'raw',
                                                        'value' => function($model) {
                                                            return '<div class="d-flex align-items-center">
                                                                    <i class="fas fa-credit-card text-warning me-3 fs-5"></i>
                                                                    <span class="fw-semibold">' . $model->getPay() . '</span>
                                                                </div>';
                                                        }
                                                    ],
                                                ],
                                                'options' => ['class' => 'table table-borderless mb-0'],
                                            ]) ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4">
                                    <!-- Боковая панель с действиями -->
                                    <div class="sidebar-actions">
                                        <!-- Прогресс статуса -->
                                        <div class="card border-0 rounded-4 shadow-sm mb-4">
                                            <div class="card-header bg-transparent border-0 p-4">
                                                <h5 class="card-title fw-bold text-dark mb-0">
                                                    <i class="fas fa-chart-line me-2 text-success"></i>Прогресс заявки
                                                </h5>
                                            </div>
                                            <div class="card-body p-4">
                                                <div class="status-progress mb-4">
                                                    <div class="progress" style="height: 10px;">
                                                        <?php
                                                        $progressWidth = [
                                                            0 => 33,
                                                            1 => 66,
                                                            2 => 100
                                                        ];
                                                        $width = $progressWidth[$model->status] ?? 0;
                                                        $config = [
                                                            0 => 'bg-warning',
                                                            1 => 'bg-info',
                                                            2 => 'bg-success'
                                                        ];
                                                        $progressClass = $config[$model->status] ?? 'bg-warning';
                                                        ?>
                                                        <div class="progress-bar <?= $progressClass ?>"
                                                             role="progressbar"
                                                             style="width: <?= $width ?>%"
                                                             aria-valuenow="<?= $width ?>"
                                                             aria-valuemin="0"
                                                             aria-valuemax="100">
                                                        </div>
                                                    </div>
                                                    <div class="d-flex justify-content-between mt-3">
                                                        <small class="text-muted <?= $model->status >= 0 ? 'text-warning fw-bold' : '' ?>">
                                                            Новая
                                                        </small>
                                                        <small class="text-muted <?= $model->status >= 1 ? 'text-info fw-bold' : '' ?>">
                                                            В процессе
                                                        </small>
                                                        <small class="text-muted <?= $model->status >= 2 ? 'text-success fw-bold' : '' ?>">
                                                            Завершено
                                                        </small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Быстрые действия -->
                                        <div class="card border-0 rounded-4 shadow-sm mb-4">
                                            <div class="card-header bg-transparent border-0 p-4">
                                                <h5 class="card-title fw-bold text-dark mb-0">
                                                    <i class="fas fa-bolt me-2 text-warning"></i>Быстрые действия
                                                </h5>
                                            </div>
                                            <div class="card-body p-4">
                                                <div class="d-grid gap-2">
                                                    <?= Html::a('<i class="fas fa-print me-2"></i>Распечатать', ['#'], [
                                                        'class' => 'btn btn-outline-primary btn-lg rounded-3 py-2'
                                                    ]) ?>
                                                    <?= Html::a('<i class="fas fa-copy me-2"></i>Копировать данные', ['#'], [
                                                        'class' => 'btn btn-outline-secondary btn-lg rounded-3 py-2'
                                                    ]) ?>
                                                    <?= Html::a('<i class="fas fa-share me-2"></i>Поделиться', ['#'], [
                                                        'class' => 'btn btn-outline-info btn-lg rounded-3 py-2'
                                                    ]) ?>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Информация о системе -->
                                        <div class="card border-0 rounded-4 shadow-sm">
                                            <div class="card-header bg-transparent border-0 p-4">
                                                <h5 class="card-title fw-bold text-dark mb-0">
                                                    <i class="fas fa-database me-2 text-muted"></i>Системная информация
                                                </h5>
                                            </div>
                                            <div class="card-body p-4">
                                                <div class="system-info">
                                                    <div class="info-item mb-3">
                                                        <small class="text-muted d-block">Создана</small>
                                                        <strong class="text-dark"><?= Yii::$app->formatter->asRelativeTime($model->date) ?></strong>
                                                    </div>
                                                    <div class="info-item mb-3">
                                                        <small class="text-muted d-block">Последнее изменение</small>
                                                        <strong class="text-dark">Недавно</strong>
                                                    </div>
                                                    <div class="info-item">
                                                        <small class="text-muted d-block">Версия данных</small>
                                                        <strong class="text-dark">v1.0</strong>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Дополнительные действия -->
                        <div class="additional-actions mt-5 pt-4 border-top">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6 class="fw-bold text-dark mb-3">
                                        <i class="fas fa-history me-2 text-primary"></i>История изменений
                                    </h6>
                                    <div class="timeline">
                                        <div class="timeline-item">
                                            <div class="timeline-marker bg-success"></div>
                                            <div class="timeline-content">
                                                <small class="text-muted">Сегодня, 10:30</small>
                                                <p class="mb-1">Статус изменен на "Новая"</p>
                                                <small class="text-muted">Администратор: Иванов И.И.</small>
                                            </div>
                                        </div>
                                        <div class="timeline-item">
                                            <div class="timeline-marker bg-primary"></div>
                                            <div class="timeline-content">
                                                <small class="text-muted">Вчера, 14:15</small>
                                                <p class="mb-1">Заявка создана</p>
                                                <small class="text-muted">Система</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$this->registerCss(<<<CSS
    .application-view-container {
        padding: 2rem 0;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        min-height: 100vh;
    }
    
    .view-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
    }
    
    .view-icon {
        transition: transform 0.3s ease;
    }
    
    .view-card:hover .view-icon {
        transform: scale(1.05);
    }
    
    /* Информационные карточки */
    .info-card {
        transition: all 0.3s ease;
        height: 100%;
    }
    
    .info-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.15) !important;
    }
    
    .info-icon {
        opacity: 0.8;
        transition: opacity 0.3s ease;
    }
    
    .info-card:hover .info-icon {
        opacity: 1;
    }
    
    /* Карточки контента */
    .card {
        transition: all 0.3s ease;
    }
    
    .card:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 20px rgba(0,0,0,0.1) !important;
    }
    
    /* Прогресс-бар */
    .status-progress .progress {
        background-color: #e9ecef;
        border-radius: 10px;
    }
    
    .status-progress .progress-bar {
        border-radius: 10px;
        transition: width 0.8s ease;
    }
    
    /* Временная линия */
    .timeline {
        position: relative;
        padding-left: 2rem;
    }
    
    .timeline-item {
        position: relative;
        padding-bottom: 1.5rem;
    }
    
    .timeline-marker {
        position: absolute;
        left: -2rem;
        top: 0.25rem;
        width: 12px;
        height: 12px;
        border-radius: 50%;
        border: 3px solid white;
        box-shadow: 0 0 0 3px #e9ecef;
    }
    
    .timeline-content {
        background: white;
        padding: 1rem;
        border-radius: 8px;
        border: 1px solid #f1f3f4;
    }
    
    .timeline-item:not(:last-child):before {
        content: '';
        position: absolute;
        left: -1.7rem;
        top: 1.2rem;
        bottom: -0.5rem;
        width: 2px;
        background: #e9ecef;
    }
    
    /* Таблица DetailView */
    .table-borderless td {
        border: none !important;
        padding: 1rem 0.5rem;
    }
    
    .table-borderless tr:not(:last-child) {
        border-bottom: 1px solid #f1f3f4;
    }
    
    /* Бейджи */
    .badge {
        font-size: 0.8rem;
        font-weight: 500;
        padding: 0.5em 1em;
    }
    
    /* Кнопки */
    .btn-primary {
        background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
        border: none;
        transition: all 0.3s ease;
    }
    
    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(67, 97, 238, 0.3) !important;
    }
    
    .btn-danger {
        background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        border: none;
        transition: all 0.3s ease;
    }
    
    .btn-danger:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(220, 53, 69, 0.3) !important;
    }
    
    .btn-outline-primary, .btn-outline-secondary, .btn-outline-info, 
    .btn-outline-success, .btn-outline-danger {
        transition: all 0.3s ease;
        border-width: 2px;
    }
    
    .btn-outline-primary:hover, .btn-outline-secondary:hover, 
    .btn-outline-info:hover, .btn-outline-success:hover, 
    .btn-outline-danger:hover {
        transform: translateY(-2px);
    }
    
    /* Анимации */
    @keyframes slideInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .view-card {
        animation: slideInUp 0.8s ease-out;
    }
    
    /* Градиенты для статусов */
    .bg-warning {
        background: linear-gradient(135deg, #ffc107 0%, #ffb300 100%) !important;
    }
    
    .bg-info {
        background: linear-gradient(135deg, #17a2b8 0%, #6f42c1 100%) !important;
    }
    
    .bg-success {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%) !important;
    }
    
    /* Адаптивность */
    @media (max-width: 768px) {
        .application-view-container {
            padding: 1rem;
        }
        
        .view-card {
            margin: 0;
            padding: 2rem 1.5rem !important;
        }
        
        .btn-lg {
            padding: 0.75rem 1.5rem;
        }
        
        .h2 {
            font-size: 1.75rem;
        }
        
        .d-flex.justify-content-between {
            flex-direction: column;
            text-align: center;
        }
        
        .action-buttons {
            margin-top: 2rem;
        }
        
        .info-card {
            margin-bottom: 1rem;
        }
        
        .sidebar-actions {
            margin-top: 2rem;
        }
    }
CSS
);

$this->registerJs(<<<JS
    // Анимация при наведении на карточки
    $('.info-card, .card').on('mouseenter', function() {
        $(this).css('transform', 'translateY(-5px)');
    }).on('mouseleave', function() {
        $(this).css('transform', 'translateY(0)');
    });
    
    // Копирование ID заявки
    $('.badge.bg-primary').on('click', function() {
        const id = $(this).text().replace('#', '');
        navigator.clipboard.writeText(id).then(function() {
            // Временное изменение стиля
            const originalText = $(this).text();
            $(this).text('Скопировано!');
            $(this).removeClass('bg-primary').addClass('bg-success');
            
            setTimeout(() => {
                $(this).text(originalText);
                $(this).removeClass('bg-success').addClass('bg-primary');
            }, 2000);
        }.bind(this));
    });
    
    // Анимация прогресс-бара при загрузке
    $(document).ready(function() {
        $('.progress-bar').each(function() {
            const width = $(this).css('width');
            $(this).css('width', '0');
            setTimeout(() => {
                $(this).animate({width: width}, 1000);
            }, 500);
        });
    });
    
    // Подсветка элементов при наведении
    $('.table-borderless tr').on('mouseenter', function() {
        $(this).css('background-color', 'rgba(67, 97, 238, 0.05)');
    }).on('mouseleave', function() {
        $(this).css('background-color', '');
    });
JS
);
?>