<?php

/**
 * @var $model
 */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Мои заявки';
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="applications-container">
        <!-- Заголовок с статистикой -->
        <div class="d-flex justify-content-between align-items-center mb-5">
            <div>
                <h1 class="display-5 fw-bold text-dark mb-2"><?= Html::encode($this->title) ?></h1>
                <p class="text-muted fs-5">Управление вашими образовательными заявками</p>
            </div>
            <div class="text-end">
                <a href="<?= Url::to(['/application/form']) ?>" class="btn btn-primary btn-lg rounded-pill px-4 py-3 shadow">
                    <i class="fas fa-plus-circle me-2"></i>Новая заявка
                </a>
            </div>
        </div>

        <?php if ($model): ?>
            <!-- Статистика заявок -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="stat-card bg-primary text-white rounded-4 p-4 text-center shadow">
                        <div class="stat-icon mb-3">
                            <i class="fas fa-clock fa-2x"></i>
                        </div>
                        <h3 class="fw-bold mb-1"><?= count(array_filter($model, fn($item) => $item->status == 0)) ?></h3>
                        <p class="mb-0 opacity-90">На рассмотрении</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-card bg-success text-white rounded-4 p-4 text-center shadow">
                        <div class="stat-icon mb-3">
                            <i class="fas fa-check-circle fa-2x"></i>
                        </div>
                        <h3 class="fw-bold mb-1"><?= count(array_filter($model, fn($item) => $item->status == 1)) ?></h3>
                        <p class="mb-0 opacity-90">Одобрено</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-card bg-warning text-white rounded-4 p-4 text-center shadow">
                        <div class="stat-icon mb-3">
                            <i class="fas fa-graduation-cap fa-2x"></i>
                        </div>
                        <h3 class="fw-bold mb-1"><?= count(array_filter($model, fn($item) => $item->status == 2)) ?></h3>
                        <p class="mb-0 opacity-90">Завершено</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-card bg-info text-white rounded-4 p-4 text-center shadow">
                        <div class="stat-icon mb-3">
                            <i class="fas fa-list-alt fa-2x"></i>
                        </div>
                        <h3 class="fw-bold mb-1"><?= count($model) ?></h3>
                        <p class="mb-0 opacity-90">Всего заявок</p>
                    </div>
                </div>
            </div>

            <!-- Список заявок -->
            <div class="applications-list">
                <?php foreach ($model as $item): ?>
                    <div class="card application-card border-0 rounded-4 shadow-sm mb-4">
                        <div class="card-header bg-transparent border-0 p-4 pb-0">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1">
                                    <h4 class="card-title fw-bold text-dark mb-2">
                                        <i class="fas fa-file-alt text-primary me-2"></i>
                                        <?= Html::encode($item->title) ?>
                                    </h4>
                                    <div class="d-flex flex-wrap gap-3 text-muted">
                                    <span class="d-flex align-items-center">
                                        <i class="fas fa-calendar me-2"></i>
                                        <?= Html::encode($item->date) ?>
                                    </span>
                                        <span class="d-flex align-items-center">
                                        <i class="fas fa-credit-card me-2"></i>
                                        <?= $item->getPay() ?>
                                    </span>
                                    </div>
                                </div>
                                <div class="status-badge">
                                    <?php
                                    $statusConfig = [
                                        0 => ['class' => 'bg-warning', 'icon' => 'clock', 'text' => 'На рассмотрении'],
                                        1 => ['class' => 'bg-success', 'icon' => 'check-circle', 'text' => 'Одобрено'],
                                        2 => ['class' => 'bg-info', 'icon' => 'graduation-cap', 'text' => 'Завершено']
                                    ];
                                    $config = $statusConfig[$item->status] ?? $statusConfig[0];
                                    ?>
                                    <span class="badge <?= $config['class'] ?> rounded-pill px-3 py-2 fs-6">
                                    <i class="fas fa-<?= $config['icon'] ?> me-1"></i>
                                    <?= $config['text'] ?>
                                </span>
                                </div>
                            </div>
                        </div>

                        <div class="card-body p-4 pt-3">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <div class="application-details">
                                        <div class="row g-3">
                                            <div class="col-sm-6">
                                                <div class="detail-item">
                                                    <small class="text-muted d-block">Способ оплаты</small>
                                                    <strong class="text-dark"><?= $item->getPay() ?></strong>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="detail-item">
                                                    <small class="text-muted d-block">Статус обработки</small>
                                                    <strong class="text-dark"><?= $item->getStatus() ?></strong>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4 text-end">
                                    <?php if ($item->status == 2): ?>
                                        <a href="<?= Url::to(['application/comment', 'id' => $item->id]) ?>"
                                           class="btn btn-success btn-lg rounded-pill px-4 py-2 shadow">
                                            <i class="fas fa-comment me-2"></i>Оставить отзыв
                                        </a>
                                    <?php else: ?>
                                        <div class="action-info">
                                            <small class="text-muted">
                                                <?php if ($item->status == 0): ?>
                                                    <i class="fas fa-info-circle me-1"></i>Заявка на рассмотрении
                                                <?php else: ?>
                                                    <i class="fas fa-check me-1"></i>Заявка одобрена
                                                <?php endif; ?>
                                            </small>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Прогресс заявки -->
                        <div class="card-footer bg-transparent border-0 p-4 pt-0">
                            <div class="application-progress">
                                <div class="progress" style="height: 8px;">
                                    <?php
                                    $progressWidth = [
                                        0 => 33,
                                        1 => 66,
                                        2 => 100
                                    ];
                                    $width = $progressWidth[$item->status] ?? 0;
                                    ?>
                                    <div class="progress-bar bg-primary"
                                         role="progressbar"
                                         style="width: <?= $width ?>%"
                                         aria-valuenow="<?= $width ?>"
                                         aria-valuemin="0"
                                         aria-valuemax="100">
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between mt-2">
                                    <small class="text-muted <?= $item->status >= 0 ? 'text-primary fw-bold' : '' ?>">
                                        <i class="fas fa-paper-plane me-1"></i>Отправлено
                                    </small>
                                    <small class="text-muted <?= $item->status >= 1 ? 'text-primary fw-bold' : '' ?>">
                                        <i class="fas fa-check me-1"></i>Одобрено
                                    </small>
                                    <small class="text-muted <?= $item->status >= 2 ? 'text-primary fw-bold' : '' ?>">
                                        <i class="fas fa-graduation-cap me-1"></i>Завершено
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

        <?php else: ?>
            <!-- Состояние пустого списка -->
            <div class="empty-state text-center py-5">
                <div class="empty-icon mb-4">
                    <i class="fas fa-file-invoice text-muted" style="font-size: 4rem;"></i>
                </div>
                <h3 class="text-muted mb-3">Заявок пока нет</h3>
                <p class="text-muted mb-4 fs-5">Создайте свою первую заявку на обучение</p>
                <a href="<?= Url::to(['/application/form']) ?>"
                   class="btn btn-primary btn-lg rounded-pill px-5 py-3 shadow">
                    <i class="fas fa-plus-circle me-2"></i>Создать первую заявку
                </a>
                <div class="mt-4">
                    <a href="<?= Yii::$app->homeUrl ?>" class="text-muted text-decoration-none">
                        <i class="fas fa-arrow-left me-1"></i>Вернуться на главную
                    </a>
                </div>
            </div>
        <?php endif; ?>
    </div>

<?php
$this->registerCss(<<<CSS
    .applications-container {
        padding: 2rem 0;
    }
    
    .stat-card {
        transition: all 0.3s ease;
        height: 100%;
    }
    
    .stat-card:hover {
        transform: translateY(-5px);
    }
    
    .application-card {
        transition: all 0.3s ease;
        background: white;
        border: 1px solid rgba(0,0,0,0.05);
    }
    
    .application-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 30px rgba(0,0,0,0.12) !important;
    }
    
    .status-badge .badge {
        font-size: 0.85rem;
        font-weight: 500;
    }
    
    .detail-item {
        padding: 0.5rem 0;
    }
    
    .application-progress .progress {
        background-color: #f1f3f4;
        border-radius: 10px;
    }
    
    .application-progress .progress-bar {
        border-radius: 10px;
        transition: width 0.8s ease;
    }
    
    .empty-state {
        background: rgba(255,255,255,0.8);
        border-radius: 20px;
        padding: 4rem 2rem;
    }
    
    .empty-icon {
        opacity: 0.5;
    }
    
    /* Анимации */
    .application-card {
        animation: slideInUp 0.5s ease-out;
    }
    
    @keyframes slideInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    /* Стили для разных статусов */
    .bg-warning {
        background: linear-gradient(135deg, #ffc107 0%, #ffb300 100%) !important;
    }
    
    .bg-success {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%) !important;
    }
    
    .bg-info {
        background: linear-gradient(135deg, #17a2b8 0%, #6f42c1 100%) !important;
    }
    
    .bg-primary {
        background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%) !important;
    }
    
    /* Адаптивность */
    @media (max-width: 768px) {
        .d-flex.justify-content-between {
            flex-direction: column;
            text-align: center;
        }
        
        .text-end {
            text-align: center !important;
            margin-top: 1rem;
        }
        
        .application-card .row > div {
            margin-bottom: 1rem;
        }
        
        .text-end {
            text-align: left !important;
        }
        
        .stat-card {
            margin-bottom: 1rem;
        }
        
        .display-5 {
            font-size: 2rem;
        }
    }
    
    /* Кастомные тени */
    .shadow-sm {
        box-shadow: 0 2px 10px rgba(0,0,0,0.08) !important;
    }
    
    .shadow {
        box-shadow: 0 5px 20px rgba(0,0,0,0.12) !important;
    }
    
    /* Плавные переходы */
    .btn {
        transition: all 0.3s ease;
    }
    
    .btn:hover {
        transform: translateY(-2px);
    }
CSS
);

$this->registerJs(<<<JS
    // Анимация появления карточек
    $(document).ready(function() {
        $('.application-card').each(function(index) {
            $(this).css('animation-delay', (index * 0.1) + 's');
        });
    });
    
    // Интерактивность прогресс-бара
    $('.application-progress .progress').hover(
        function() {
            $(this).css('transform', 'scale(1.02)');
        },
        function() {
            $(this).css('transform', 'scale(1)');
        }
    );
JS
);
?>