<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>" class="h-100">
    <head>
        <title><?= Html::encode($this->title) ?></title>
        <?php $this->head() ?>
    </head>
    <body class="d-flex flex-column h-100">
    <?php $this->beginBody() ?>

    <header id="header">
        <?php
        NavBar::begin([
            'brandLabel' => '<span class="brand-text">Корочки.есть</span>',
            'brandUrl' => Yii::$app->homeUrl,
            'options' => [
                'class' => 'navbar-expand-lg navbar-dark bg-primary fixed-top shadow',
                'style' => 'background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;'
            ],
            'brandOptions' => [
                'class' => 'navbar-brand d-flex align-items-center fw-bold fs-3'
            ]
        ]);

        echo Nav::widget([
            'options' => ['class' => 'navbar-nav ms-auto align-items-center'],
            'items' => [
                [
                    'label' => '<i class="fas fa-home me-1"></i>Главная',
                    'url' => ['/site/index'],
                    'encode' => false,
                    'linkOptions' => ['class' => 'nav-link text-white fw-semibold']
                ],
                [
                    'label' => '<i class="fas fa-list me-1"></i>Заявки',
                    'url' => ['/application/index'],
                    'visible' => !Yii::$app->user->isGuest,
                    'encode' => false,
                    'linkOptions' => ['class' => 'nav-link text-white fw-semibold']
                ],
                [
                    'label' => '<i class="fas fa-plus-circle me-1"></i>Формирование заявки',
                    'url' => ['/application/form'],
                    'visible' => !Yii::$app->user->isGuest,
                    'encode' => false,
                    'linkOptions' => ['class' => 'nav-link text-white fw-semibold']
                ],
                [
                    'label' => '<i class="fas fa-user-plus me-1"></i>Регистрация',
                    'url' => ['/site/register'],
                    'visible' => Yii::$app->user->isGuest,
                    'encode' => false,
                    'linkOptions' => ['class' => 'nav-link text-white fw-semibold']
                ],
                [
                    'label' => '<i class="fas fa-cog me-1"></i>Админ-панель',
                    'url' => ['/admin'],
                    'visible' => !Yii::$app->user->isGuest && Yii::$app->user->identity->isAdmin(),
                    'encode' => false,
                    'linkOptions' => ['class' => 'nav-link text-white fw-semibold']
                ],
                Yii::$app->user->isGuest
                    ? [
                    'label' => '<i class="fas fa-sign-in-alt me-1"></i>Авторизация',
                    'url' => ['/site/login'],
                    'encode' => false,
                    'linkOptions' => ['class' => 'nav-link text-white fw-semibold']
                ]
                    : '<li class="nav-item">'
                    . Html::beginForm(['/site/logout'], 'post', ['class' => 'd-flex'])
                    . Html::submitButton(
                        '<i class="fas fa-sign-out-alt me-1"></i>Выйти (' . Yii::$app->user->identity->login . ')',
                        ['class' => 'btn btn-outline-light btn-sm fw-semibold']
                    )
                    . Html::endForm()
                    . '</li>'
            ]
        ]);
        NavBar::end();
        ?>
    </header>

    <main id="main" class="flex-shrink-0" role="main" style="margin-top: 76px;">
        <div class="container-xxl py-4">
            <!-- Хлебные крошки -->
            <?php if (!empty($this->params['breadcrumbs'])): ?>
                <nav aria-label="breadcrumb" class="mb-4">
                    <?= Breadcrumbs::widget([
                        'links' => $this->params['breadcrumbs'],
                        'options' => ['class' => 'breadcrumb bg-light rounded-pill px-4 py-2 shadow-sm'],
                        'itemTemplate' => '<li class="breadcrumb-item">{link}</li>',
                        'activeItemTemplate' => '<li class="breadcrumb-item active" aria-current="page">{link}</li>'
                    ]) ?>
                </nav>
            <?php endif ?>

            <!-- Уведомления -->
            <?= Alert::widget() ?>

            <!-- Основной контент -->
            <div class="content-wrapper">
                <?= $content ?>
            </div>
        </div>
    </main>

    <footer id="footer" class="mt-auto bg-dark text-light py-4">
        <div class="container-xxl">
            <div class="row align-items-center">
                <div class="col-md-6 text-center text-md-start">
                    <div class="d-flex align-items-center justify-content-center justify-content-md-start">
                        <?= Html::img('@web/images/logo-white.svg', [
                            'alt' => 'Корочки.есть',
                            'class' => 'footer-logo me-2',
                            'style' => 'height: 30px;'
                        ]) ?>
                        <span class="fw-semibold fs-5">Корочки.есть</span>
                    </div>
                    <p class="mb-0 mt-2 text-muted small">Профессиональное решение для ваших документов</p>
                </div>
                <div class="col-md-6 text-center text-md-end mt-3 mt-md-0">
                    <div class="social-links mb-2">
                        <a href="#" class="text-light me-3"><i class="fab fa-telegram fa-lg"></i></a>
                        <a href="#" class="text-light me-3"><i class="fab fa-vk fa-lg"></i></a>
                        <a href="#" class="text-light"><i class="fas fa-envelope fa-lg"></i></a>
                    </div>
                    <div class="text-muted small">
                        &copy; <?= date('Y') ?> Корочки.есть. Все права защищены.
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>