<?php

/** @var yii\web\View $this */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Главная';
?>
    <section class="hero-section py-5" style="
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    margin-top: 76px;
    color: white;
">
        <div class="container">
            <div class="row align-items-center min-vh-50 py-5">
                <div class="col-lg-6">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4 animate-fade-in">Получите новую профессию онлайн</h1>
                        <p class="lead mb-4 fs-5 opacity-90 animate-slide-up">Портал «Корочки.есть» предлагает курсы дополнительного профессионального образования с выдачей документов государственного образца.</p>
                        <div class="d-flex flex-wrap gap-3 animate-slide-up" style="animation-delay: 0.2s">
                            <?php if (!Yii::$app->user->isGuest): ?>
                                <a href="<?= Url::to(['/application/index']) ?>" class="btn btn-light btn-lg px-4 py-3 fw-semibold rounded-pill shadow">
                                    <i class="fas fa-list me-2"></i>Мои заявки
                                </a>
                                <a href="<?= Url::to(['/application/form']) ?>" class="btn btn-outline-light btn-lg px-4 py-3 fw-semibold rounded-pill">
                                    <i class="fas fa-plus-circle me-2"></i>Формирование заявки
                                </a>
                            <?php else: ?>
                                <a href="<?= Url::to(['/site/register']) ?>" class="btn btn-light btn-lg px-4 py-3 fw-semibold rounded-pill shadow">
                                    <i class="fas fa-user-plus me-2"></i>Начать обучение
                                </a>
                                <a href="<?= Url::to(['/site/login']) ?>" class="btn btn-outline-light btn-lg px-4 py-3 fw-semibold rounded-pill">
                                    <i class="fas fa-sign-in-alt me-2"></i>Войти в систему
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 text-center">
                    <div class="hero-image animate-float">
                        <?= Html::img('@web/images/1.webp', [
                            'alt' => 'Образование онлайн',
                            'class' => 'img-fluid rounded-3 shadow-lg',
                            'style' => 'max-height: 400px; object-fit: cover; border: 3px solid rgba(255,255,255,0.2);'
                        ]) ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Преимущества -->
    <section class="features-section py-5 bg-light">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col">
                    <h2 class="fw-bold display-5 mb-3">Почему выбирают нас?</h2>
                    <p class="text-muted fs-5">Мы делаем дополнительное образование доступным и эффективным</p>
                </div>
            </div>
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="card feature-card h-100 border-0 rounded-4 shadow-sm">
                        <div class="card-body text-center p-4">
                            <div class="feature-icon mb-4">
                                <div class="icon-wrapper bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                    <i class="fas fa-file-certificate text-white" style="font-size: 2rem;"></i>
                                </div>
                            </div>
                            <h5 class="card-title fw-bold mb-3">Документы гос. образца</h5>
                            <p class="card-text text-muted">Все выпускники получают удостоверения или дипломы, признаваемые работодателями по всей России.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card feature-card h-100 border-0 rounded-4 shadow-sm">
                        <div class="card-body text-center p-4">
                            <div class="feature-icon mb-4">
                                <div class="icon-wrapper bg-success rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                    <i class="fas fa-laptop text-white" style="font-size: 2rem;"></i>
                                </div>
                            </div>
                            <h5 class="card-title fw-bold mb-3">Учитесь из любой точки</h5>
                            <p class="card-text text-muted">Доступ к материалам 24/7 с любого устройства. Сочетайте обучение с работой и личной жизнью.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card feature-card h-100 border-0 rounded-4 shadow-sm">
                        <div class="card-body text-center p-4">
                            <div class="feature-icon mb-4">
                                <div class="icon-wrapper bg-warning rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                    <i class="fas fa-chalkboard-teacher text-white" style="font-size: 2rem;"></i>
                                </div>
                            </div>
                            <h5 class="card-title fw-bold mb-3">Опытные преподаватели</h5>
                            <p class="card-text text-muted">Практикующие специалисты с многолетним опытом работы в своих областях. Только актуальные знания.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Статистика -->
    <section class="stats-section py-5 bg-white">
        <div class="container">
            <div class="row g-4 text-center">
                <div class="col-md-3">
                    <div class="stat-item">
                        <div class="stat-number display-4 fw-bold text-primary mb-2">5000+</div>
                        <div class="stat-label text-muted fw-semibold">Выпускников</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-item">
                        <div class="stat-number display-4 fw-bold text-success mb-2">150+</div>
                        <div class="stat-label text-muted fw-semibold">Курсов</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-item">
                        <div class="stat-number display-4 fw-bold text-warning mb-2">98%</div>
                        <div class="stat-label text-muted fw-semibold">Довольных клиентов</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-item">
                        <div class="stat-number display-4 fw-bold text-info mb-2">24/7</div>
                        <div class="stat-label text-muted fw-semibold">Поддержка</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Отзывы -->
    <section class="testimonials-section py-5 bg-light">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col">
                    <h2 class="fw-bold display-5 mb-3">Отзывы наших студентов</h2>
                    <p class="text-muted fs-5">Реальные истории успеха от наших выпускников</p>
                </div>
            </div>

            <div class="row g-4">
                <?php if (!empty($comments)): ?>
                    <?php foreach ($comments as $index => $comment): ?>
                        <div class="col-md-4">
                            <div class="card testimonial-card h-100 border-0 rounded-4 shadow-sm">
                                <div class="card-body p-4">
                                    <div class="testimonial-quote mb-3">
                                        <i class="fas fa-quote-left text-primary opacity-25" style="font-size: 2rem;"></i>
                                    </div>
                                    <p class="card-text fs-6 text-muted">"<?= Html::encode($comment->text) ?>"</p>
                                    <div class="d-flex align-items-center mt-4 pt-3 border-top">
                                        <div class="user-avatar bg-primary rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                        <span class="text-white fw-bold fs-6">
                                            <?= strtoupper(mb_substr($comment->user->first_name ?? 'П', 0, 1)) ?>
                                        </span>
                                        </div>
                                        <div>
                                            <h6 class="mb-0 fw-bold">
                                                <?= Html::encode($comment->user->first_name . ' ' . $comment->user->last_name ?? 'Пользователь') ?>
                                            </h6>
                                            <small class="text-muted">
                                                <?php if ($comment->application): ?>
                                                    Курс: <?= Html::encode($comment->application->title ?? '') ?>
                                                <?php else: ?>
                                                    Слушатель курса
                                                <?php endif; ?>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-12 text-center py-5">
                        <div class="empty-state">
                            <i class="fas fa-comments text-muted mb-3" style="font-size: 4rem;"></i>
                            <h4 class="text-muted">Пока нет отзывов</h4>
                            <p class="text-muted">Будьте первым, кто поделится своим опытом!</p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- CTA секция -->
    <section class="cta-section py-5 bg-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 text-center">
                    <div class="cta-content">
                        <h2 class="fw-bold display-5 mb-4">Готовы начать обучение?</h2>
                        <p class="lead mb-4 fs-5 text-muted">Присоединяйтесь к тысячам студентов, которые уже получили новые знания и изменили свою карьеру с помощью наших курсов.</p>
                        <div class="d-flex flex-wrap gap-3 justify-content-center">
                            <?php if (!Yii::$app->user->isGuest): ?>
                                <a href="<?= Url::to(['/application/index']) ?>" class="btn btn-primary btn-lg px-5 py-3 fw-semibold rounded-pill shadow">
                                    <i class="fas fa-list me-2"></i>Мои заявки
                                </a>
                                <a href="<?= Url::to(['/application/form']) ?>" class="btn btn-outline-primary btn-lg px-5 py-3 fw-semibold rounded-pill">
                                    <i class="fas fa-plus-circle me-2"></i>Формирование заявки
                                </a>
                            <?php else: ?>
                                <a href="<?= Url::to(['/site/register']) ?>" class="btn btn-primary btn-lg px-5 py-3 fw-semibold rounded-pill shadow">
                                    <i class="fas fa-rocket me-2"></i>Начать обучение
                                </a>
                                <a href="<?= Url::to(['/site/login']) ?>" class="btn btn-outline-primary btn-lg px-5 py-3 fw-semibold rounded-pill">
                                    <i class="fas fa-sign-in-alt me-2"></i>Войти в систему
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php
$this->registerCss(<<<CSS
    .min-vh-50 {
        min-height: 50vh;
    }
    
    .hero-section {
        position: relative;
        overflow: hidden;
    }
    
    .feature-card {
        transition: all 0.3s ease;
        background: white;
    }
    
    .feature-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 40px rgba(0,0,0,0.1) !important;
    }
    
    .icon-wrapper {
        transition: transform 0.3s ease;
    }
    
    .feature-card:hover .icon-wrapper {
        transform: scale(1.1);
    }
    
    .testimonial-card {
        transition: all 0.3s ease;
        background: white;
    }
    
    .testimonial-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(0,0,0,0.1) !important;
    }
    
    .user-avatar {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }
    
    .stat-item {
        padding: 20px;
    }
    
    .stat-number {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    /* Анимации */
    .animate-fade-in {
        animation: fadeIn 1s ease-in;
    }
    
    .animate-slide-up {
        animation: slideUp 0.8s ease-out;
    }
    
    .animate-float {
        animation: float 6s ease-in-out infinite;
    }
    
    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
    
    @keyframes slideUp {
        from { 
            opacity: 0;
            transform: translateY(30px);
        }
        to { 
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    @keyframes float {
        0%, 100% { transform: translateY(0px); }
        50% { transform: translateY(-20px); }
    }
    
    .empty-state {
        opacity: 0.7;
    }
    
    /* Адаптивность */
    @media (max-width: 768px) {
        .display-4 {
            font-size: 2.5rem;
        }
        
        .hero-section {
            text-align: center;
        }
        
        .btn-lg {
            width: 100%;
            margin-bottom: 10px;
        }
        
        .d-flex.gap-3 {
            flex-direction: column;
        }
    }
CSS
);
?>