<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */
/** @var app\models\RegisterForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;
use yii\widgets\MaskedInput;

$this->title = 'Регистрация';
$this->params['breadcrumbs'][] = $this->title;
?>
    <div class="auth-container">
        <div class="row justify-content-center align-items-center min-vh-80 py-5">
            <div class="col-xl-6 col-lg-8 col-md-10">
                <!-- Карточка регистрации -->
                <div class="card auth-card border-0 shadow-lg rounded-4">
                    <div class="card-body p-5">
                        <!-- Заголовок -->
                        <div class="text-center mb-5">
                            <div class="auth-icon mb-4">
                                <div class="icon-wrapper bg-success rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                    <i class="fas fa-user-plus text-white" style="font-size: 2rem;"></i>
                                </div>
                            </div>
                            <h1 class="h2 fw-bold text-dark mb-2">Создайте аккаунт</h1>
                            <p class="text-muted">Присоединяйтесь к нашему сообществу обучающихся</p>
                        </div>

                        <?php $form = ActiveForm::begin([
                            'id' => 'register-form',
                            'fieldConfig' => [
                                'template' => "{label}\n{input}\n{error}",
                                'labelOptions' => ['class' => 'form-label fw-semibold text-dark mb-2'],
                                'inputOptions' => ['class' => 'form-control form-control-lg py-3'],
                                'errorOptions' => ['class' => 'invalid-feedback d-block'],
                            ],
                            'options' => [
                                'class' => 'auth-form'
                            ]
                        ]); ?>

                        <div class="row">
                            <!-- Логин -->
                            <div class="col-md-6 mb-4">
                                <div class="form-floating">
                                    <?= $form->field($model, 'login')->textInput([
                                        'autofocus' => true,
                                        'placeholder' => ' ',
                                        'class' => 'form-control form-control-lg py-3 rounded-3'
                                    ])->label('Логин') ?>
                                    <div class="form-icon">
                                        <i class="fas fa-user text-muted"></i>
                                    </div>
                                </div>
                            </div>

                            <!-- Email -->
                            <div class="col-md-6 mb-4">
                                <div class="form-floating">
                                    <?= $form->field($model, 'email')->textInput([
                                        'placeholder' => ' ',
                                        'class' => 'form-control form-control-lg py-3 rounded-3'
                                    ])->label('Email') ?>
                                    <div class="form-icon">
                                        <i class="fas fa-envelope text-muted"></i>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Имя -->
                            <div class="col-md-4 mb-4">
                                <div class="form-floating">
                                    <?= $form->field($model, 'first_name')->textInput([
                                        'placeholder' => ' ',
                                        'class' => 'form-control form-control-lg py-3 rounded-3'
                                    ])->label('Имя') ?>
                                    <div class="form-icon">
                                        <i class="fas fa-signature text-muted"></i>
                                    </div>
                                </div>
                            </div>

                            <!-- Фамилия -->
                            <div class="col-md-4 mb-4">
                                <div class="form-floating">
                                    <?= $form->field($model, 'last_name')->textInput([
                                        'placeholder' => ' ',
                                        'class' => 'form-control form-control-lg py-3 rounded-3'
                                    ])->label('Фамилия') ?>
                                    <div class="form-icon">
                                        <i class="fas fa-user-tag text-muted"></i>
                                    </div>
                                </div>
                            </div>

                            <!-- Отчество -->
                            <div class="col-md-4 mb-4">
                                <div class="form-floating">
                                    <?= $form->field($model, 'patronymic')->textInput([
                                        'placeholder' => ' ',
                                        'class' => 'form-control form-control-lg py-3 rounded-3'
                                    ])->label('Отчество') ?>
                                    <div class="form-icon">
                                        <i class="fas fa-user-circle text-muted"></i>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Телефон -->
                            <div class="col-md-6 mb-4">
                                <div class="form-floating">
                                    <?= $form->field($model, 'phone')->widget(MaskedInput::class, [
                                        'mask' => '8(999)999-99-99',
                                        'options' => [
                                            'class' => 'form-control form-control-lg py-3 rounded-3',
                                            'placeholder' => ' ',
                                        ]
                                    ])->label('Телефон') ?>
                                    <div class="form-icon">
                                        <i class="fas fa-phone text-muted"></i>
                                    </div>
                                </div>
                            </div>

                            <!-- Пароль -->
                            <div class="col-md-6 mb-4">
                                <div class="form-floating position-relative">
                                    <?= $form->field($model, 'password')->passwordInput([
                                        'placeholder' => ' ',
                                        'class' => 'form-control form-control-lg py-3 rounded-3 password-input'
                                    ])->label('Пароль') ?>
                                    <div class="form-icon">
                                        <i class="fas fa-lock text-muted"></i>
                                    </div>
                                    <button type="button" class="btn btn-link password-toggle" style="position: absolute; right: 15px; top: 50%; transform: translateY(-50%); z-index: 5;">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Индикатор сложности пароля -->
                        <div class="password-strength mb-4">
                            <div class="progress" style="height: 6px;">
                                <div class="progress-bar" role="progressbar" style="width: 0%; transition: width 0.3s ease;"></div>
                            </div>
                            <small class="text-muted password-strength-text">Надежность пароля</small>
                        </div>

                        <!-- Соглашения -->
                        <div class="mb-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="agreeTerms" required>
                                <label class="form-check-label text-muted small" for="agreeTerms">
                                    Я соглашаюсь с <a href="#" class="text-decoration-none">условиями использования</a>
                                    и <a href="#" class="text-decoration-none">политикой конфиденциальности</a>
                                </label>
                            </div>
                        </div>

                        <!-- Кнопка регистрации -->
                        <div class="d-grid mb-4">
                            <?= Html::submitButton('<i class="fas fa-user-plus me-2"></i>Создать аккаунт', [
                                'class' => 'btn btn-success btn-lg py-3 fw-semibold rounded-3 shadow',
                                'name' => 'register-button',
                                'id' => 'register-btn'
                            ]) ?>
                        </div>

                        <?php ActiveForm::end(); ?>

                        <!-- Разделитель -->
                        <div class="divider d-flex align-items-center my-4">
                            <div class="border-top flex-grow-1"></div>
                            <div class="px-3 text-muted small">или</div>
                            <div class="border-top flex-grow-1"></div>
                        </div>

                        <!-- Ссылка на авторизацию -->
                        <div class="text-center">
                            <p class="text-muted mb-0">Уже есть аккаунт?</p>
                            <a href="<?= \yii\helpers\Url::to(['site/login']) ?>" class="btn btn-outline-primary btn-lg rounded-3 px-4 mt-3">
                                <i class="fas fa-sign-in-alt me-2"></i>Войти в систему
                            </a>
                        </div>

                        <!-- Дополнительные ссылки -->
                        <div class="text-center mt-4 pt-3 border-top">
                            <a href="<?= Yii::$app->homeUrl ?>" class="text-muted text-decoration-none">
                                <i class="fas fa-arrow-left me-1"></i>Вернуться на главную
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Декоративные элементы -->
                <div class="auth-decoration">
                    <div class="decoration-circle decoration-circle-1"></div>
                    <div class="decoration-circle decoration-circle-2"></div>
                    <div class="decoration-circle decoration-circle-3"></div>
                </div>
            </div>
        </div>
    </div>

<?php
$this->registerCss(<<<CSS
    .min-vh-80 {
        min-height: 80vh;
        padding: 2rem 0;
    }
    
    .auth-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        position: relative;
        z-index: 2;
    }
    
    .auth-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        position: relative;
        overflow: hidden;
    }
    
    .auth-icon {
        transition: transform 0.3s ease;
    }
    
    .auth-card:hover .auth-icon {
        transform: scale(1.05);
    }
    
    /* Стили для полей формы */
    .form-floating {
        position: relative;
    }
    
    .form-floating > .form-control {
        padding-left: 3rem;
        border: 2px solid #e9ecef;
        transition: all 0.3s ease;
    }
    
    .form-floating > .form-control:focus {
        border-color: #28a745;
        box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25);
    }
    
    .form-icon {
        position: absolute;
        left: 1rem;
        top: 50%;
        transform: translateY(-50%);
        z-index: 4;
        font-size: 1.1rem;
    }
    
    .form-floating > label {
        padding-left: 3rem;
        z-index: 3;
    }
    
    /* Переключатель видимости пароля */
    .password-toggle {
        color: #6c757d;
        text-decoration: none;
        border: none;
        background: none;
    }
    
    .password-toggle:hover {
        color: #28a745;
    }
    
    /* Индикатор сложности пароля */
    .password-strength {
        margin-top: -0.5rem;
    }
    
    .password-strength .progress {
        background-color: #e9ecef;
        border-radius: 3px;
    }
    
    .password-strength-text {
        display: block;
        margin-top: 0.25rem;
    }
    
    /* Чекбокс */
    .form-check-input:checked {
        background-color: #28a745;
        border-color: #28a745;
    }
    
    .form-check-input:focus {
        border-color: #28a745;
        box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25);
    }
    
    /* Кнопки */
    .btn-success {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        border: none;
        transition: all 0.3s ease;
    }
    
    .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(40, 167, 69, 0.3) !important;
    }
    
    .btn-outline-primary {
        border: 2px solid #4361ee;
        color: #4361ee;
        transition: all 0.3s ease;
    }
    
    .btn-outline-primary:hover {
        background: #4361ee;
        border-color: #4361ee;
        transform: translateY(-2px);
    }
    
    /* Разделитель */
    .divider .border-top {
        border-top-color: #dee2e6 !important;
    }
    
    /* Декоративные элементы */
    .auth-decoration {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        pointer-events: none;
        z-index: 1;
    }
    
    .decoration-circle {
        position: absolute;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.1);
        animation: float 6s ease-in-out infinite;
    }
    
    .decoration-circle-1 {
        width: 120px;
        height: 120px;
        top: 15%;
        left: 5%;
        animation-delay: 0s;
    }
    
    .decoration-circle-2 {
        width: 80px;
        height: 80px;
        top: 70%;
        right: 8%;
        animation-delay: 2s;
    }
    
    .decoration-circle-3 {
        width: 100px;
        height: 100px;
        bottom: 10%;
        left: 15%;
        animation-delay: 4s;
    }
    
    /* Анимации */
    @keyframes float {
        0%, 100% { 
            transform: translateY(0px) rotate(0deg); 
        }
        50% { 
            transform: translateY(-20px) rotate(180deg); 
        }
    }
    
    /* Анимация появления формы */
    .auth-card {
        animation: slideUpFade 0.8s ease-out;
    }
    
    @keyframes slideUpFade {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    /* Стили для строк формы */
    .row {
        margin-left: -0.5rem;
        margin-right: -0.5rem;
    }
    
    .row > [class*="col-"] {
        padding-left: 0.5rem;
        padding-right: 0.5rem;
    }
    
    /* Адаптивность */
    @media (max-width: 768px) {
        .auth-card {
            margin: 1rem;
            padding: 2rem 1.5rem !important;
        }
        
        .btn-lg {
            padding: 0.75rem 1.5rem;
        }
        
        .h2 {
            font-size: 1.75rem;
        }
        
        .row > [class*="col-"] {
            margin-bottom: 1rem;
        }
    }
    
    /* Кастомный скроллбар */
    ::-webkit-scrollbar {
        width: 8px;
    }
    
    ::-webkit-scrollbar-track {
        background: #f1f1f1;
    }
    
    ::-webkit-scrollbar-thumb {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        border-radius: 10px;
    }
    
    /* Валидация */
    .is-invalid {
        border-color: #dc3545 !important;
    }
    
    .is-valid {
        border-color: #28a745 !important;
    }
CSS
);

$this->registerJs(<<<JS
    // Переключение видимости пароля
    $(document).on('click', '.password-toggle', function() {
        const passwordInput = $(this).closest('.form-floating').find('.password-input');
        const icon = $(this).find('i');
        
        if (passwordInput.attr('type') === 'password') {
            passwordInput.attr('type', 'text');
            icon.removeClass('fa-eye').addClass('fa-eye-slash');
        } else {
            passwordInput.attr('type', 'password');
            icon.removeClass('fa-eye-slash').addClass('fa-eye');
        }
    });
    
    // Анимация при фокусе на поля
    $('.form-control').on('focus', function() {
        $(this).closest('.form-floating').find('.form-icon').css('color', '#28a745');
    }).on('blur', function() {
        $(this).closest('.form-floating').find('.form-icon').css('color', '#6c757d');
    });
    
    // Индикатор сложности пароля
    $('.password-input').on('input', function() {
        const password = $(this).val();
        const strengthBar = $('.password-strength .progress-bar');
        const strengthText = $('.password-strength-text');
        
        let strength = 0;
        let text = 'Надежность пароля';
        let color = '#dc3545';
        
        if (password.length >= 8) strength += 25;
        if (password.match(/[a-z]/) && password.match(/[A-Z]/)) strength += 25;
        if (password.match(/\d/)) strength += 25;
        if (password.match(/[^a-zA-Z\d]/)) strength += 25;
        
        if (strength >= 75) {
            text = 'Сильный пароль';
            color = '#28a745';
        } else if (strength >= 50) {
            text = 'Средний пароль';
            color = '#ffc107';
        } else if (strength >= 25) {
            text = 'Слабый пароль';
            color = '#fd7e14';
        } else {
            text = 'Очень слабый пароль';
            color = '#dc3545';
        }
        
        strengthBar.css({
            'width': strength + '%',
            'background-color': color
        });
        strengthText.text(text).css('color', color);
    });
    
    // Валидация формы
    $('#register-form').on('submit', function(e) {
        if (!$('#agreeTerms').is(':checked')) {
            e.preventDefault();
            $('#agreeTerms').focus();
            alert('Пожалуйста, согласитесь с условиями использования');
        }
    });
JS
);
?>